<?php
/**
 * Plugin Name: Notification : Prevent Duplicated
 * Description: Fixes the bug of multiple notifications being sent at once.
 * Author: BracketSpace
 * Author URI: https://bracketspace.com
 * Version: 1.0.0
 * License: GPL2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) or exit;

// Callback should return unique value from the trigger.
$covered_triggers = [
	'BracketSpace\Notification\Defaults\Trigger\Post\PostTrigger' => function( $trigger ) {
		return $trigger->{ $trigger->get_post_type() }->get_id();
	},
	'BracketSpace\Notification\Defaults\Trigger\User\UserTrigger' => function( $trigger ) {
		return $trigger->user_id;
	},
	'BracketSpace\Notification\Defaults\Trigger\Comment\CommentTrigger' => function( $trigger ) {
		return $trigger->comment->comment_ID;
	},
];

function notification_dep_transient_name( $notification, $object_id ) {
	return sprintf( '%s_%s', $notification->get_hash(), $object_id );
}

// Save the lock for a couple of seconds.
add_action( 'notification/sent', function( $notification, $trigger ) use ( $covered_triggers ) {

	foreach ( $covered_triggers as $class_name => $callback ) {
		if ( $trigger instanceof $class_name ) {
			set_transient( nsku5e_transient_name( $notification, $callback( $trigger ) ), time(), 60 );
			return;
		}
	}

}, 10, 2 );

// If the lock is present, suppress the Notification.
add_filter( 'notification/should_send', function( $should_send, $notification, $trigger ) use ( $covered_triggers ) {

	if ( ! in_array( $trigger->get_slug(), array_keys( $covered_triggers ), true ) ) {
		return $should_send;
	}

	$object_id = $covered_triggers[ $trigger->get_slug() ]( $trigger );

	if ( false !== get_transient( notification_dep_transient_name( $notification, $object_id ) ) ) {
		return false;
	}

	return $should_send;

}, 1000, 3 );